/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator;

import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.APIHTTPConnector;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class OAuthToken
implements Token {
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());
    private String clientID;
    private String clientSecret;
    private String redirectURL;
    private String grantToken;
    private String refreshToken;
    private String accessToken;
    private String expiresIn;
    private String userMail;
    private String id;

    public OAuthToken(String clientID, String clientSecret, String token, TokenType type) {
        this(clientID, clientSecret, token, type, null);
    }

    public OAuthToken(String clientID, String clientSecret, String token, TokenType type, String redirectURL) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.grantToken = type.equals((Object)TokenType.GRANT) ? token : null;
        this.refreshToken = type.equals((Object)TokenType.REFRESH) ? token : null;
        this.redirectURL = redirectURL;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getGrantToken() {
        return this.grantToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getUserMail() {
        return this.userMail;
    }

    public void setUserMail(String userMail) {
        this.userMail = userMail;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public synchronized void authenticate(APIHTTPConnector urlConnection) throws SDKException {
        Initializer initializer = Initializer.getInitializer();
        TokenStore store = initializer.getStore();
        UserSignature user = initializer.getUser();
        OAuthToken oauthToken = (OAuthToken)store.getToken(initializer.getUser(), this);
        String token = "";
        if (oauthToken == null) {
            token = this.refreshToken != null ? this.refreshAccessToken(user, store).getAccessToken() : this.generateAccessToken(user, store).getAccessToken();
        } else if (Long.valueOf(oauthToken.getExpiresIn()) - System.currentTimeMillis() < 5000L) {
            LOGGER.log(Level.INFO, "Access Token has expired. Hence refreshing.");
            token = oauthToken.refreshAccessToken(user, store).getAccessToken();
        } else {
            token = oauthToken.getAccessToken();
        }
        urlConnection.addHeader("Authorization", "Zoho-oauthtoken " + token);
    }

    private String getResponseFromServer(HashMap<String, String> requestParams) throws SDKException {
        try {
            String USER_AGENT = "Mozilla/5.0";
            String url = Initializer.getInitializer().getEnvironment().getAccountsUrl();
            CloseableHttpClient client = this.getHttpClient();
            HttpPost post = new HttpPost(url);
            post.setHeader("user-agent", "Mozilla/5.0");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            if (requestParams != null && !requestParams.isEmpty()) {
                for (String key : requestParams.keySet()) {
                    String value = requestParams.get(key);
                    if (value == null) continue;
                    urlParameters.add(new BasicNameValuePair(key, value));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            return EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)post).getEntity());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new SDKException(ex);
        }
    }

    private CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        SSLContext sslContext = SSLContext.getDefault();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
    }

    private OAuthToken refreshAccessToken(UserSignature user, TokenStore store) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("client_id", this.clientID);
        requestParams.put("client_secret", this.clientSecret);
        requestParams.put("redirect_uri", this.redirectURL);
        requestParams.put("grant_type", "refresh_token");
        requestParams.put("refresh_token", this.refreshToken);
        String response = this.getResponseFromServer(requestParams);
        try {
            store.saveToken(user, this.parseResponse(response));
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception in saving tokens : ", ex);
        }
        return this;
    }

    private OAuthToken generateAccessToken(UserSignature user, TokenStore store) throws SDKException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("client_id", this.clientID);
        requestParams.put("client_secret", this.clientSecret);
        requestParams.put("redirect_uri", this.redirectURL);
        requestParams.put("grant_type", "authorization_code");
        requestParams.put("code", this.grantToken);
        String response = this.getResponseFromServer(requestParams);
        try {
            store.saveToken(user, this.parseResponse(response));
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException("Exception in saving tokens : ", ex);
        }
        return this;
    }

    private OAuthToken parseResponse(String response) throws SDKException {
        JSONObject responseJSON = new JSONObject(response);
        if (!responseJSON.has("access_token")) {
            throw new SDKException("INVALID CLIENT ERROR", responseJSON.getString("error"));
        }
        this.setAccessToken(responseJSON.getString("access_token"));
        this.setExpiresIn(String.valueOf(this.getTokenExpiresIn(responseJSON)));
        if (responseJSON.has("refresh_token")) {
            this.refreshToken = responseJSON.getString("refresh_token");
        }
        return this;
    }

    private Long getTokenExpiresIn(JSONObject response) {
        return System.currentTimeMillis() + (response.has("expires_in_sec") ? response.getLong("expires_in") : (long)(response.getInt("expires_in") * 1000));
    }

    @Override
    public Boolean remove() throws SDKException {
        try {
            Initializer.getInitializer().getStore().deleteToken(this);
            return true;
        }
        catch (SDKException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SDKException(ex);
        }
    }

    public static enum TokenType {
        GRANT,
        REFRESH;

    }
}

