/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator.store;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DBStore
implements TokenStore {
    private String userName;
    private String portNumber;
    private String password;
    private String host;
    private String databaseName;
    private String connectionString;

    public DBStore() {
        this(null, null, null, null, null);
    }

    public DBStore(String host, String databaseName, String userName, String password, String portNumber) {
        this.host = host != null ? host : "localhost";
        this.databaseName = databaseName != null ? databaseName : "zohooauth";
        this.userName = userName != null ? userName : "root";
        this.password = password != null ? password : "";
        this.portNumber = portNumber != null ? portNumber : "3306";
        this.connectionString = "jdbc:mysql://" + this.host + ":" + this.portNumber + "/" + this.databaseName + "?allowPublicKeyRetrieval=true&useSSL=false";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token getToken(UserSignature user, Token token) throws SDKException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                if (!(token instanceof OAuthToken)) return null;
                OAuthToken oauthToken = (OAuthToken)token;
                try (Statement statement = connection.createStatement();){
                    String query = this.constructDBQuery(user.getEmail(), oauthToken, false);
                    try (ResultSet result = statement.executeQuery(query);){
                        if (!result.next()) return null;
                        oauthToken.setAccessToken(result.getString(5));
                        oauthToken.setExpiresIn(String.valueOf(result.getString(7)));
                        oauthToken.setRefreshToken(result.getString(4));
                        OAuthToken oAuthToken = oauthToken;
                        return oAuthToken;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getToken - DBStore : ", ex);
        }
    }

    @Override
    public void saveToken(UserSignature user, Token token) throws SDKException {
        block26: {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                    if (!(token instanceof OAuthToken)) break block26;
                    OAuthToken oauthToken = (OAuthToken)token;
                    oauthToken.setUserMail(user.getEmail());
                    this.deleteToken(oauthToken);
                    try (PreparedStatement statement = connection.prepareStatement("insert into oauthtoken(user_mail, client_id, refresh_token, access_token, grant_token, expiry_time) values(?,?,?,?,?,?)");){
                        statement.setString(1, user.getEmail());
                        statement.setString(2, oauthToken.getClientID());
                        statement.setString(3, oauthToken.getRefreshToken());
                        statement.setString(4, oauthToken.getAccessToken());
                        statement.setString(5, oauthToken.getGrantToken());
                        statement.setString(6, oauthToken.getExpiresIn());
                        statement.executeUpdate();
                    }
                }
            }
            catch (Exception ex) {
                throw new SDKException("TOKEN_STORE", "Exception in saveToken - DBStore : ", ex);
            }
        }
    }

    @Override
    public void deleteToken(Token token) throws SDKException {
        block27: {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                    if (!(token instanceof OAuthToken)) break block27;
                    String query = this.constructDBQuery(((OAuthToken)token).getUserMail(), (OAuthToken)token, true);
                    try (PreparedStatement statement = connection.prepareStatement(query);){
                        statement.executeUpdate();
                    }
                }
            }
            catch (SDKException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SDKException("TOKEN_STORE", "Exception in deleteToken - DBStore : ", ex);
            }
        }
    }

    @Override
    public List<Token> getTokens() throws SDKException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                 Statement statement = connection.createStatement();){
                String query = "select * from oauthtoken;";
                try (ResultSet result = statement.executeQuery(query);){
                    while (result.next()) {
                        OAuthToken.TokenType tokenType = result.getString(6) != null && !result.getString(6).equalsIgnoreCase("null") && !result.getString(6).isEmpty() ? OAuthToken.TokenType.GRANT : OAuthToken.TokenType.REFRESH;
                        String tokenValue = tokenType.equals((Object)OAuthToken.TokenType.REFRESH) ? result.getString(4) : result.getString(6);
                        OAuthToken token = new OAuthToken(result.getString(3), null, tokenValue, tokenType);
                        token.setId(result.getString(1));
                        token.setUserMail(result.getString(2));
                        token.setRefreshToken(result.getString(4));
                        token.setAccessToken(result.getString(5));
                        token.setExpiresIn(String.valueOf(result.getString(7)));
                        tokens.add(token);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokens - DBStore : ", ex);
        }
        return tokens;
    }

    @Override
    public void deleteTokens() throws SDKException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                String query = "delete from oauthtoken";
                try (PreparedStatement statement = connection.prepareStatement(query);){
                    statement.executeUpdate();
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteTokens - DBStore : ", ex);
        }
    }

    private String constructDBQuery(String email, OAuthToken token, boolean isDelete) throws SDKException {
        if (email == null) {
            throw new SDKException("USER MAIL NULL ERROR", "User Mail MUST NOT be null. Use setUserMail() to set value.");
        }
        String query = isDelete ? "delete from " : "select * from ";
        query = query + "oauthtoken where user_mail='" + email + "' and client_id='" + token.getClientID() + "' and ";
        query = token.getGrantToken() != null ? query + "grant_token='" + token.getGrantToken() + "'" : query + "refresh_token='" + token.getRefreshToken() + "'";
        return query;
    }
}

