/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.relatedrecords;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.relatedrecords.ActionHandler;
import com.zoho.crm.api.relatedrecords.BodyWrapper;
import com.zoho.crm.api.relatedrecords.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import com.zoho.crm.api.util.Utility;
import java.time.OffsetDateTime;

public class RelatedRecordsOperations {
    private String moduleAPIName;
    private Long recordId;
    private String relatedListAPIName;

    public RelatedRecordsOperations(String relatedListAPIName, Long recordId, String moduleAPIName) {
        this.relatedListAPIName = relatedListAPIName;
        this.recordId = recordId;
        this.moduleAPIName = moduleAPIName;
    }

    public APIResponse<ResponseHandler> getRelatedRecords(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRelatedRecords(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> delinkRecords(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getRelatedRecord(Long relatedRecordId, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(relatedRecordId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateRelatedRecord(Long relatedRecordId, BodyWrapper request, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(relatedRecordId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setHeader(headerInstance);
        Utility.getRelatedLists(this.relatedListAPIName, this.moduleAPIName, handlerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> delinkRecord(Long relatedRecordId, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.relatedListAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(relatedRecordId.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class DelinkRecordHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.DelinkRecordHeader");
    }

    public static class UpdateRelatedRecordHeader {
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.UpdateRelatedRecordHeader");
    }

    public static class GetRelatedRecordHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordHeader");
    }

    public static class DelinkRecordsParam {
        public static final Param<Long> IDS = new Param("ids", "com.zoho.crm.api.RelatedRecords.DelinkRecordsParam");
    }

    public static class GetRelatedRecordsHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsHeader");
        public static final Header<String> X_EXTERNAL = new Header("X-EXTERNAL", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsHeader");
    }

    public static class GetRelatedRecordsParam {
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.RelatedRecords.GetRelatedRecordsParam");
    }
}

