/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.APIHTTPConnector;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.Constants;
import com.zoho.crm.api.util.Converter;
import com.zoho.crm.api.util.Downloader;
import com.zoho.crm.api.util.FormDataConverter;
import com.zoho.crm.api.util.JSONConverter;
import com.zoho.crm.api.util.Model;
import com.zoho.crm.api.util.XMLConverter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;

public class CommonAPIHandler {
    private String apiPath;
    private ParameterMap param = new ParameterMap();
    private HeaderMap header = new HeaderMap();
    private Object request;
    private String httpMethod;
    private String moduleAPIName;
    private String contentType;
    private String categoryMethod;
    private Boolean mandatoryChecker;
    protected static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setAPIPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public <T> void addParam(Param<T> paramInstance, T paramValue) throws SDKException {
        if (paramValue == null) {
            return;
        }
        if (this.param == null) {
            this.param = new ParameterMap();
        }
        this.param.add(paramInstance, paramValue);
    }

    public <T> void addHeader(Header<T> headerInstance, T headerValue) throws SDKException {
        if (headerValue == null) {
            return;
        }
        if (this.header == null) {
            this.header = new HeaderMap();
        }
        this.header.add(headerInstance, headerValue);
    }

    public void setParam(ParameterMap param) {
        if (param == null) {
            return;
        }
        if (this.param.getParameterMap() != null && !this.param.getParameterMap().isEmpty()) {
            this.param.getParameterMap().putAll(param.getParameterMap());
        } else {
            this.param = param;
        }
    }

    public String getModuleAPIName() {
        return this.moduleAPIName;
    }

    public void setModuleAPIName(String moduleAPIName) {
        this.moduleAPIName = moduleAPIName;
    }

    public void setHeader(HeaderMap header) {
        if (header == null) {
            return;
        }
        if (this.header.getHeaderMap() != null && !this.header.getHeaderMap().isEmpty()) {
            this.header.getHeaderMap().putAll(header.getHeaderMap());
        } else {
            this.header = header;
        }
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public <T> APIResponse<T> apiCall(Class<T> className, String encodeType) throws SDKException {
        if (Initializer.getInitializer() == null) {
            throw new SDKException("SDK UNINITIALIZED ERROR", "SDK is UnInitialized");
        }
        APIHTTPConnector connector = new APIHTTPConnector();
        try {
            this.setAPIUrl(connector);
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in setting API URL : ", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in setting API URL : ", exception);
            throw exception;
        }
        connector.setRequestMethod(this.httpMethod);
        connector.setContentType(this.contentType);
        if (this.header != null && this.header.getHeaderMap().size() > 0) {
            connector.setHeaders(this.header.getHeaderMap());
        }
        if (this.param != null && this.param.getParameterMap().size() > 0) {
            connector.setParams(this.param.getParameterMap());
        }
        try {
            Initializer.getInitializer().getToken().authenticate(connector);
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in authenticating current request : ", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in authenticating current request : ", exception);
            throw exception;
        }
        String pack = className.getCanonicalName();
        Converter convertInstance = null;
        if (this.contentType != null && Constants.IS_GENERATE_REQUEST_BODY.contains(this.httpMethod.toUpperCase())) {
            Object request = null;
            try {
                convertInstance = this.getConverterClassInstance(this.contentType.toLowerCase());
                request = convertInstance.formRequest(this.request, this.request.getClass().getCanonicalName(), null, null);
            }
            catch (SDKException e) {
                LOGGER.log(Level.SEVERE, "Exception in forming request body : ", e);
                throw e;
            }
            catch (Exception e) {
                SDKException exception = new SDKException(e);
                LOGGER.log(Level.SEVERE, "Exception in forming request body : ", exception);
                throw exception;
            }
            connector.setRequestBody(request);
        }
        try {
            connector.addHeader("X-ZOHO-SDK", System.getProperty("os.name") + "/" + System.getProperty("os.version") + " Java/" + System.getProperty("java.version") + ":" + "3.1.0");
            HttpResponse response = connector.fireRequest(convertInstance);
            int statusCode = response.getStatusLine().getStatusCode();
            HashMap<String, String> headerMap = this.getHeaders(response.getAllHeaders());
            boolean isModel = false;
            ContentType contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
            String mimeType = contentType.getMimeType();
            convertInstance = this.getConverterClassInstance(mimeType.toLowerCase());
            Model returnObject = (Model)convertInstance.getWrappedResponse(response, pack);
            if (returnObject != null && (pack.equals(returnObject.getClass().getCanonicalName()) || this.isExpectedType(returnObject, pack))) {
                isModel = true;
            }
            return new APIResponse(headerMap, statusCode, returnObject, isModel);
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in current API call execution : ", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in current API call execution : ", exception);
            throw exception;
        }
    }

    public Converter getConverterClassInstance(String encodeType) {
        switch (encodeType) {
            case "application/json": 
            case "text/plain": 
            case "application/ld+json": {
                return new JSONConverter(this);
            }
            case "application/xml": 
            case "text/xml": {
                return new XMLConverter(this);
            }
            case "multipart/form-data": {
                return new FormDataConverter(this);
            }
            case "image/png": 
            case "image/jpeg": 
            case "image/gif": 
            case "image/tiff": 
            case "image/svg+xml": 
            case "image/bmp": 
            case "image/webp": 
            case "text/csv": 
            case "text/html": 
            case "text/css": 
            case "text/javascript": 
            case "text/calendar": 
            case "application/x-download": 
            case "application/zip": 
            case "application/pdf": 
            case "application/java-archive": 
            case "application/javascript": 
            case "application/octet-stream": 
            case "application/xhtml+xml": 
            case "application/x-bzip": 
            case "application/msword": 
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": 
            case "application/gzip": 
            case "application/x-httpd-php": 
            case "application/vnd.ms-powerpoint": 
            case "application/vnd.rar": 
            case "application/x-sh": 
            case "application/x-tar": 
            case "application/vnd.ms-excel": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": 
            case "application/x-7z-compressed": 
            case "audio/mpeg": 
            case "audio/x-ms-wma": 
            case "audio/vnd.rn-realaudio": 
            case "audio/x-wav": 
            case "audio/3gpp": 
            case "audio/3gpp2": 
            case "video/mpeg": 
            case "video/mp4": 
            case "video/webm": 
            case "video/3gpp": 
            case "video/3gpp2": 
            case "font/ttf": {
                return new Downloader(this);
            }
        }
        return null;
    }

    private HashMap<String, String> getHeaders(org.apache.http.Header[] headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (org.apache.http.Header header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        return headerMap;
    }

    private boolean isExpectedType(Model model, String className) {
        Class<?>[] interfaces;
        for (Class<?> interfaceDetails : interfaces = model.getClass().getInterfaces()) {
            if (!interfaceDetails.getCanonicalName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private void setAPIUrl(APIHTTPConnector connector) throws SDKException {
        String APIPath = new String();
        if (this.apiPath.contains("http")) {
            if (this.apiPath.contains("content.zohoapis.com")) {
                APIPath = APIPath.concat(Initializer.getInitializer().getEnvironment().getFileUploadUrl());
                try {
                    URL uri = new URL(this.apiPath);
                    APIPath = APIPath.concat(uri.getPath());
                }
                catch (MalformedURLException ex) {
                    SDKException excp = new SDKException(ex);
                    LOGGER.log(Level.SEVERE, "Invalid URL Error", excp);
                    throw excp;
                }
            } else {
                if (this.apiPath.substring(0, 1).equalsIgnoreCase("/")) {
                    this.apiPath = this.apiPath.substring(1);
                }
                APIPath = APIPath.concat(this.apiPath);
            }
        } else {
            APIPath = APIPath.concat(Initializer.getInitializer().getEnvironment().getUrl());
            APIPath = APIPath.concat(this.apiPath);
        }
        connector.setURL(APIPath);
    }

    public Boolean isMandatoryChecker() {
        return this.mandatoryChecker;
    }

    public void setMandatoryChecker(Boolean mandatoryChecker) {
        this.mandatoryChecker = mandatoryChecker;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getCategoryMethod() {
        return this.categoryMethod;
    }

    public void setCategoryMethod(String category) {
        this.categoryMethod = category;
    }

    public String getAPIPath() {
        return this.apiPath;
    }
}

