/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.api.authenticator.store;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.exception.SDKException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DBStore
implements TokenStore {
    private String userName;
    private String portNumber;
    private String password;
    private String host;
    private String databaseName;
    private String connectionString;
    private String tableName;

    private DBStore(String host, String databaseName, String tableName, String userName, String password, String portNumber) {
        this.host = host;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.userName = userName;
        this.password = password;
        this.portNumber = portNumber;
        this.connectionString = "jdbc:mysql://" + this.host + ":" + this.portNumber + "/" + this.databaseName + "?allowPublicKeyRetrieval=true&useSSL=false";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Token getToken(UserSignature user, Token token) throws SDKException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                if (!(token instanceof OAuthToken)) return null;
                try (Statement statement = connection.createStatement();){
                    OAuthToken oauthToken = (OAuthToken)token;
                    String query = this.constructDBQuery(user.getEmail(), oauthToken, false);
                    try (ResultSet result = statement.executeQuery(query);){
                        if (!result.next()) return null;
                        oauthToken.setId(result.getString(1));
                        oauthToken.setUserMail(result.getString(2));
                        oauthToken.setClientId(result.getString(3));
                        oauthToken.setClientSecret(result.getString(4));
                        oauthToken.setRefreshToken(result.getString(5));
                        oauthToken.setAccessToken(result.getString(6));
                        oauthToken.setGrantToken(result.getString(7));
                        oauthToken.setExpiresIn(String.valueOf(result.getString(8)));
                        oauthToken.setRedirectURL(result.getString(9));
                        OAuthToken oAuthToken = oauthToken;
                        return oAuthToken;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getToken - DBStore : ", ex);
        }
    }

    @Override
    public void saveToken(UserSignature user, Token token) throws SDKException {
        block26: {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                    if (!(token instanceof OAuthToken)) break block26;
                    OAuthToken oauthToken = (OAuthToken)token;
                    oauthToken.setUserMail(user.getEmail());
                    this.deleteToken(oauthToken);
                    try (PreparedStatement statement = connection.prepareStatement("insert into " + this.tableName + "(id,user_mail,client_id,client_secret,refresh_token,access_token,grant_token,expiry_time,redirect_url) values(?,?,?,?,?,?,?,?,?)");){
                        statement.setString(1, oauthToken.getId());
                        statement.setString(2, user.getEmail());
                        statement.setString(3, oauthToken.getClientId());
                        statement.setString(4, oauthToken.getClientSecret());
                        statement.setString(5, oauthToken.getRefreshToken());
                        statement.setString(6, oauthToken.getAccessToken());
                        statement.setString(7, oauthToken.getGrantToken());
                        statement.setString(8, oauthToken.getExpiresIn());
                        statement.setString(9, oauthToken.getRedirectURL());
                        statement.executeUpdate();
                    }
                }
            }
            catch (Exception ex) {
                throw new SDKException("TOKEN_STORE", "Exception in saveToken - DBStore : ", ex);
            }
        }
    }

    @Override
    public void deleteToken(Token token) throws SDKException {
        block27: {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                    if (!(token instanceof OAuthToken)) break block27;
                    String query = this.constructDBQuery(((OAuthToken)token).getUserMail(), (OAuthToken)token, true);
                    try (PreparedStatement statement = connection.prepareStatement(query);){
                        statement.executeUpdate();
                    }
                }
            }
            catch (SDKException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SDKException("TOKEN_STORE", "Exception in deleteToken - DBStore : ", ex);
            }
        }
    }

    @Override
    public List<Token> getTokens() throws SDKException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                 Statement statement = connection.createStatement();){
                String query = "select * from " + this.tableName + ";";
                try (ResultSet result = statement.executeQuery(query);){
                    while (result.next()) {
                        OAuthToken oauthToken = new OAuthToken.Builder().clientID(result.getString(3)).clientSecret(result.getString(4)).grantToken(result.getString(7)).refreshToken(result.getString(5)).build();
                        oauthToken.setId(result.getString(1));
                        oauthToken.setUserMail(result.getString(2));
                        oauthToken.setAccessToken(result.getString(6));
                        oauthToken.setExpiresIn(String.valueOf(result.getString(8)));
                        oauthToken.setRedirectURL(result.getString(9));
                        tokens.add(oauthToken);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in getTokens - DBStore : ", ex);
        }
        return tokens;
    }

    @Override
    public void deleteTokens() throws SDKException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try (Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);){
                String query = "delete from " + this.tableName;
                try (PreparedStatement statement = connection.prepareStatement(query);){
                    statement.executeUpdate();
                }
            }
        }
        catch (Exception ex) {
            throw new SDKException("TOKEN_STORE", "Exception in deleteTokens - DBStore : ", ex);
        }
    }

    private String constructDBQuery(String email, OAuthToken token, boolean isDelete) throws SDKException {
        if (email == null) {
            throw new SDKException("USER MAIL NULL ERROR", "User Mail MUST NOT be null. Use setUserMail() to set value.");
        }
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(isDelete ? "delete from " : "select * from ");
        queryBuilder.append(this.tableName).append(" where user_mail='").append(email);
        queryBuilder.append("' and client_id='").append(token.getClientId()).append("' and ");
        if (token.getGrantToken() != null) {
            queryBuilder.append("grant_token='").append(token.getGrantToken()).append("'");
        } else {
            queryBuilder.append("refresh_token='").append(token.getRefreshToken()).append("'");
        }
        return queryBuilder.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Token getTokenById(String id, Token token) throws SDKException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Builder {
        private String userName = "root";
        private String portNumber = "3306";
        private String password = "";
        private String host = "localhost";
        private String databaseName = "zohooauth";
        private String tableName = "oauthtoken";

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder portNumber(String portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DBStore build() {
            return new DBStore(this.host, this.databaseName, this.tableName, this.userName, this.password, this.portNumber);
        }
    }
}

