/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.attachments;

import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.attachments.ActionHandler;
import com.zoho.crm.api.attachments.FileBodyWrapper;
import com.zoho.crm.api.attachments.ResponseHandler;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;

public class AttachmentsOperations {
    private Long recordId;
    private String moduleAPIName;

    public AttachmentsOperations(String moduleAPIName, Long recordId) {
        this.moduleAPIName = moduleAPIName;
        this.recordId = recordId;
    }

    public APIResponse<ResponseHandler> downloadAttachment(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Attachments/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        return handlerInstance.apiCall(ResponseHandler.class, "application/x-download");
    }

    public APIResponse<ActionHandler> deleteAttachment(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Attachments/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getAttachments(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Attachments");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> uploadAttachment(FileBodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Attachments");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("multipart/form-data");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> uploadLinkAttachment(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Attachments");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setMandatoryChecker(true);
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteAttachments(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/");
        apiPath = apiPath.concat(this.moduleAPIName.toString());
        apiPath = apiPath.concat("/");
        apiPath = apiPath.concat(this.recordId.toString());
        apiPath = apiPath.concat("/Attachments");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class DeleteAttachmentsParam {
        public static final Param<Long> IDS = new Param("ids", "com.zoho.crm.api.Attachments.DeleteAttachmentsParam");
    }

    public static class UploadLinkAttachmentParam {
        public static final Param<String> ATTACHMENTURL = new Param("attachmentUrl", "com.zoho.crm.api.Attachments.UploadLinkAttachmentParam");
    }

    public static class GetAttachmentsParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Attachments.GetAttachmentsParam");
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.Attachments.GetAttachmentsParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.Attachments.GetAttachmentsParam");
    }
}

